import shutil, tempfile, os
import unittest

from os import path

class TestCaseBase(unittest.TestCase):

    def setUp(self):
        # Create a temporary directory
        self.test_dir = tempfile.mkdtemp()
        # print("Using test folder: " + self.test_dir)
    
    def tearDown(self):
        # Remove the directory after the test
        shutil.rmtree(self.test_dir)

    def list_test_dir(self):
        return os.listdir(self.test_dir)

    def write_sample_file(self, name, contents):
        with open(path.join(self.test_dir, name), 'w', encoding='utf-8') as f:
            f.write(contents)
    
    def assert_file_contents(self, expected_content, file):
        with open(file, encoding='utf-8') as f:
            c = f.read()
            self.assertEqual(expected_content, c)

    def assert_manifest_contents(self, expected_sha, entry_name, file):
        with open(file, encoding='utf-8') as f:
            c = f.read()
            a, b = c.split()
            self.assertEqual(expected_sha, a)
            self.assertEqual(entry_name, b)

    def assert_same_payload(self, expected_resources, sample):
        self.assertEqual(len(expected_resources), len(sample))
        payload_sources = []
        for v in sample.values():
            payload_sources.append(v["src"])
        self.assert_same_entries(expected_resources, payload_sources)

    def assert_same_entries(self, expected_entries, sample):
        self.assertEqual(len(expected_entries), len(sample))
        for expected in expected_entries:
            self.assertIn(expected, sample)

    def sample_resource(self, file_name):
        resource_path = os.path.join(os.path.dirname(__file__), 
                            'samples',
                            file_name)
        self.assertTrue(path.isfile(resource_path))
        return resource_path

    assertSameEntries = assert_same_entries