from tkinter import *
from tkinter.constants import *

import math

import logging
logger = logging.getLogger(__name__)

class ScrollableFrame(Frame):
    def __init__(self, container, size_lookup_fn):
        super().__init__(container)
        self.size_lookup_fn = size_lookup_fn
        canvas = Canvas(self, bg="gray50")
        scrollbar = Scrollbar(self, orient="vertical", command=canvas.yview)
        self.scrollable_frame = Frame(canvas, 
            highlightbackground="gray50",
            highlightcolor="gray50", 
            highlightthickness=10)
        self.canvas = canvas
        self.container = container
        self.scrollable_frame.bind(
            "<Configure>",
            lambda e: canvas.configure(
                scrollregion=canvas.bbox("all")
            )
        )
        self.canvas.bind("<Configure>", lambda e: self.resize(e.width))
        self.inner_window_id = canvas.create_window((0, 0), window=self.scrollable_frame, anchor=N)
        canvas.configure(yscrollcommand=scrollbar.set)
        canvas.pack(side="left", fill=BOTH, expand=True)
        scrollbar.pack(side="right", fill="y")

    def layout(self):
        w=self.canvas.winfo_width()
        self.resize(w)

    def resize(self, w):
        inner_width = self.size_lookup_fn()
        margin = math.floor((w - inner_width) / 2)
        if margin < 0:
            margin = 0
        self.canvas.coords(self.inner_window_id, margin, 20)


class SimpleHeaderFrame(Frame):
    def __init__(self, application, enable_back=True):
        self.application = application
        parent = application.window
        Frame.__init__(self, parent, bg="gray50")
        header = Frame(self)
        self.backbutton = None
        if enable_back:
            btn = Button(header, text="Back", command=self.on_back_button)
            btn.place(x=10, y=10)
            self.backbutton = btn
        heading_text=self.heading_text()     
        lbl = Label(header, textvariable=heading_text, pady=10)
        lbl.config(font=("Helvetica", 16))
        lbl.pack()
        self.lbl = lbl
        header.pack(fill=X)
        body = Frame(self, bg="gray50")
        body.pack(expand=True, fill=BOTH)
        self.body = body
        self.build_body(body)
        
    def on_back_button(self):
        pass

    def heading_text(self):
        return StringVar()

    def build_body(self, body):
        pass

    def present(self, **kwargs):
        self.pack(fill=BOTH, expand=True)

class LocalizableElement():

    def __init__(self) -> None:
        self.labels = {}

    def textlabel(self, label_key):
        text = StringVar()
        text.set(_(label_key))
        self.labels[label_key] = text
        return text

    def on_lang_change(self):
        logger.debug("changing language")
        for k, l in self.labels.items():
            l.set(_(k))