from tkinter import *

class ToolbarButton(Button):
    def __init__(self, parent, **kwargs):
        self.label = kwargs["text"]
        super().__init__(parent, **kwargs)

    def rebind(self):
        self["text"] = _(self.label)

class Toolbar(Frame):
    def __init__(self, application, main_frame):
        self.application = application
        self.main_frame = main_frame
        profile = application.current_profile

        parent = application.window
        Frame.__init__(self, parent, bg="gray50")
        label = Label(self, text = "Current package:", fg = "white", bg="gray50")  
        label.pack(side=LEFT, anchor="w", padx=5)
        
        self.button1 = ToolbarButton(self, text="Payload", command=self.show_payload, padx=20)
        self.button1.pack(side=LEFT, padx=5)

        self.button2 = ToolbarButton(self, text="Metadata", command=self.show_metadata, padx=20)
        self.button2.pack(side=LEFT, padx=5)

        self.button3 = ToolbarButton(self, text="Process", command=self.show_process, padx=20)
        self.button3.pack(side=LEFT, padx=5)

        profile_label = Frame(self, bg="steel blue", width=250, height=70, padx=10, cursor="hand2")
        profile_label.pack(side=RIGHT, fill=Y)
        profile_label.bind("<Button-1>", lambda x: self.application.show_screen("pick_profile"))

        current_user = Label(profile_label, text=profile.name, fg="white", bg="steel blue", padx=5, anchor=W)
        current_user.place(y=6)
        current_user.bind("<Button-1>", lambda x: self.application.show_screen("pick_profile"))

        profile = Label(profile_label, text=profile.org_label, fg="white", bg="steel blue", padx=5, anchor=W)
        profile.config(font=("Helvetica", 10))
        profile.place(y=36)
        profile.bind("<Button-1>", lambda x: self.application.show_screen("pick_profile"))

        self.profile_org_label = profile
        self.current_user = current_user

        application.add_languagelistener(self)

    def choose1(self):
        self.main_frame.choose(0)
    
    def show_payload(self):
        self.main_frame.choose(1)
    
    def show_metadata(self):
        self.main_frame.choose(2)

    def show_process(self):
        self.main_frame.choose(3)

    def choose5(self):
        self.main_frame.choose(4)

    def show_first_options(self):
        self.button1["state"] = "normal"
        self.button2["state"] = "normal"
        self.button3["state"] = "disabled"

    def show_save(self):
        self.button3["state"] = "normal"
    
    def hide_options(self):
        self.button1["state"] = "disabled"
        self.button2["state"] = "disabled"
        self.button3["state"] = "disabled"

    def rebind(self):
        profile = self.application.current_profile
        self.current_user.configure(text = profile.name)
        self.profile_org_label.configure(text = profile.org_label)

    def on_lang_change(self):
        self.button1.rebind()
        self.button2.rebind()
        self.button3.rebind()