import tkinter
from tkinter import *
from tkinter import scrolledtext

import logging
logger = logging.getLogger(__name__)


SAVE_PANEL_BG_COLOR = "LightBlue2"

SAVE_AS_DIP_MSG = """
------------------------------------------------------------
                        Saving as a DIP
------------------------------------------------------------
"""

SAVE_AS_AIP_MSG = """
------------------------------------------------------------
                        Saving as a AIP
------------------------------------------------------------
"""

class SavePanel(Frame):

    def __init__(self, parent, application):
        self.application = application
        Frame.__init__(self, parent, bg=SAVE_PANEL_BG_COLOR)

        buttons_frame = Frame(self, bg=SAVE_PANEL_BG_COLOR)
        buttons_frame.pack(side="top")

        buttons_label = Label(buttons_frame, text = "Process as: ", bg=SAVE_PANEL_BG_COLOR)
        buttons_label.pack(side="left")

        self.type = IntVar(value=2)
        sip_option = Radiobutton(buttons_frame, text="SIP", variable=self.type, value=1, command=self.select_type, bg=SAVE_PANEL_BG_COLOR)
        sip_option.pack(side="left", padx=10, pady=8, anchor="n")

        aip_option = Radiobutton(buttons_frame, text="AIP", variable=self.type, value=2, command=self.select_type, bg=SAVE_PANEL_BG_COLOR)
        aip_option.pack(side="left", padx=10, pady=8, anchor="n")

        dip_option = Radiobutton(buttons_frame, text="DIP", variable=self.type, value=3, command=self.select_type, bg=SAVE_PANEL_BG_COLOR)
        dip_option.pack(side="left", padx=10, pady=8, anchor="n")

        checkbox_frame = Frame(self, bg=SAVE_PANEL_BG_COLOR)
        checkbox_frame.pack(side="top")

        self.encrypt = IntVar(value=0)
        self.encrypt_check = Checkbutton(checkbox_frame, text="Encrypt", variable=self.encrypt, bg=SAVE_PANEL_BG_COLOR)
        self.encrypt_check.pack(side="left")
        self.double = IntVar(value=1)
        self.double_check = Checkbutton(checkbox_frame, text="Double bag", variable=self.double, bg=SAVE_PANEL_BG_COLOR)
        self.double_check.pack(side="left")

        process_btn_frame = Frame(self, bg=SAVE_PANEL_BG_COLOR)
        process_btn_frame.pack(side="top")

        process_btn = Button(process_btn_frame, text="Process", command=self.process, padx=20, pady=10)
        process_btn.pack(side="top", pady=(8,0))

        text = tkinter.scrolledtext.ScrolledText(self, bg="white", fg="black")
        text.configure(state=tkinter.DISABLED)
        text.bind("<Button>", lambda event: text.focus_set())
        text.pack(side="bottom", anchor="s", expand=True, padx=10, pady=10, fill=BOTH)
        self.text = text

    def write_log_line(self, line):
        self.text.configure(state=tkinter.NORMAL)
        self.text.insert("end-1c", line + "\n\n")
        self.text.configure(state=tkinter.DISABLED)
        self.text.see(tkinter.END)

    def save_as_sip(self):
        # self.workspace.save_as_sip()
        self.write_log_line("*** To be implemented: saving as a SIP ***")

    def save_as_aip(self):
        encrypt = bool(self.encrypt.get())
        double_bag = bool(self.double.get())
        self.write_log_line(SAVE_AS_AIP_MSG)
        self.workspace.save_as_aip(encryption=encrypt, double_bag=double_bag, reporter=self.write_log_line)

    def save_as_dip(self):
        self.write_log_line(SAVE_AS_DIP_MSG)
        self.workspace.save_as_dip(reporter=self.write_log_line)
        # self.write_log_line("To be implemented: saving as a DIP")

    def select_type(self):
        logger.debug("Selecting type: %s", self.type)
        if (self.type.get() == 1 or self.type.get() == 2):
            self.double_check['state'] = "normal"
            self.encrypt_check['state'] = "normal"
        else:
            self.double_check['state'] = "disabled"
            self.encrypt_check['state'] = "disabled"

    def process(self):
        if (self.type.get() == 1):
            self.save_as_sip()
        elif (self.type.get() == 2):
            self.save_as_aip()
        elif (self.type.get() == 3):
            self.save_as_dip()

    def switch_package(self, workspace):
        self.workspace = workspace

    def rebind(self):
        logger.debug("rebind")
        if not(self.application.encryption_enabled()):
            self.encrypt_check["state"] = "disabled"

