from tkinter import *

class MetadataPanel(Frame):

    def __init__(self, parent, application):
        self.application = application
        Frame.__init__(self, parent)

        title = Label(self, padx=10, pady=10,  text="User generated:")
        title.pack(side="top", anchor="w", pady=10)

        form = Frame(self, highlightbackground="grey80",
            highlightcolor="grey80", highlightthickness=5, pady=5, padx=10)
        form.pack(side="top", fill=X, expand=True, padx=0, pady=0)

        field_model = [
            {
                "field": "accession_reference",
                "label": "Accession reference",
            },
            {
                "field": "catalogue_reference",
                "label": "Reference number",
            },
            {
                "field": "title",
                "label": "Title",
            },
            {
                "field": "access_restriction",
                "label": "Access restriction",
            },
            {
                "field": "use_restriction",
                "label": "Use restriction",
            }
        ]

        self.field_vars = {}
        self.form = form

        for m in field_model:
            field_name = m["field"]
            field_label = m["label"]
            val = self.field_vars[field_name] = StringVar()
            f = Frame(form)
            f.pack(side="top", fill=X, expand=True)
            l = Label(f, padx=10, pady=10,  text=field_label, width=20, anchor=E)
            l.pack(side="left", fill=X, padx=0, pady=0)
            e = Entry(f, textvariable=val)
            e.pack(side="left", fill=X, expand=True, padx=4, pady=4, ipadx=6, ipady=6)
            on_change = lambda x : self.on_field_change()
            e.bind('<FocusOut>', on_change)
            e.bind('<Leave>', on_change)

        title2 = Label(self, padx=10, pady=10,  text="System generated:")
        title2.pack(side="top", anchor="w", pady=10)

        system_form = Frame(self, highlightbackground="grey80",
            highlightcolor="grey80", highlightthickness=5, pady=5, padx=10)
        system_form.pack(side="top", fill=X, expand=True, padx=0, pady=0)

        field_model2 = [
            {
                "field": "Bagging-Date",
                "label": "Bagging date",
            },
            {
                "field": "Bag-Software-Agent",
                "label": "Bag software agent",
            }
        ]

        for m in field_model2:
            field_name = m["field"]
            field_label = m["label"]
            val = self.field_vars[field_name] = StringVar()
            f = Frame(system_form)
            f.pack(side="top", fill=X, expand=True)
            l = Label(f, padx=10, pady=10,  text=field_label, width=20, anchor=E)
            l.pack(side="left", fill=X, padx=0, pady=0)
            e = Entry(f, textvariable=val, state='disabled')
            e.pack(side="left", fill=X, expand=True, padx=4, pady=4, ipadx=6, ipady=6)

    def switch_package(self, workspace):
        self.workspace = workspace
        for (field, var) in self.field_vars.items():
            metadata_value = self.workspace.get_meta(field)
            var.set(metadata_value)

    def on_field_change(self):
        for (field_name, var) in self.field_vars.items():
            self.workspace.set_meta(field_name, var.get())
            self.workspace.persist_state()