from tkinter import *

import logging
logger = logging.getLogger(__name__)

class HomePanel(Frame):

    def __init__(self, parent, packaging_context):
        Frame.__init__(self, parent)
        self.packaging_context = packaging_context
        self.application = packaging_context.application
        center = Frame(self)
        center.place(relx=0.5, rely=0.5, anchor=CENTER)

        button = Button(center, text="New package", width=15, height=4, padx=10, pady=2, command=self.new_package_btn)
        button.grid(row=0, column=1)

        frame = Frame(center, width=10)
        frame.grid(row=0, column=2)

        button = Button(center, text="Resume package", width=15, height=4, padx=10, pady=2, command=self.resume_package_btn)
        button.grid(row=0, column=3)
        self.resume_btn = button

        frame = Frame(center, width=10)
        frame.grid(row=0, column=4)

        button = Button(center, text="Open package", width=15, height=4, padx=10, pady=2, command=self.application.open_pkg)
        button.grid(row=0, column=5)

        self.on_state_change()
    
    def new_package_btn(self):
        self.packaging_context.new_package()

    def resume_package_btn(self):
        self.packaging_context.resume_package()

    def on_state_change(self):
        self.resume_btn['state'] = "normal" if self.application.packaging_workspace.can_resume() else "disable"
