import tkinter as tk
from tkinter import *
from tkinter import scrolledtext

import logging
logger = logging.getLogger(__name__)

class DetailsPanel(Frame):

    def __init__(self, parent, application):
        self.application = application
        Frame.__init__(self, parent, bg="khaki1")

        repackagebtn = Button(self, text= "Process in workspace", command=self.repackage)
        repackagebtn.place(anchor=tk.NE, relx = 1, x =-10, y = 10)
        self.repackagebtn = repackagebtn

        showinnerbtn = Button(self, text= "Show inner bag", command=self.show_inner_bag, state=DISABLED)
        showinnerbtn.place(anchor=tk.NE, relx = 1, x =-10, y = 50)
        self.showinnerbtn = showinnerbtn

        details_label = Label(self, text = "Package details", bg="khaki1", font='Helvetica 18 bold')
        details_label.pack(side="top", anchor="w", padx=30, pady=20)
        
        name_frame = Frame(self, bg="khaki1")
        name_frame.pack(side="top", anchor="w")
        
        name_label = Label(name_frame, text = "Package ID: ", bg="khaki1", font='Helvetica 12 bold')
        name_label.pack(side="left", anchor="w", padx=30, pady=10)

        self.st = scrolledtext.ScrolledText(self, width=50,  height=10)
        self.st.pack(fill=tk.BOTH, side=tk.LEFT, expand=True)

        self.name = StringVar()
        name_value = Label(name_frame, textvariable=self.name, bg="khaki1", wraplength=500, justify=LEFT)
        name_value.pack(side="left", anchor="w", padx=0, pady=10)

    def switch_package(self, workspace):
        self.workspace = workspace


    def repackage(self):
        self.application.packaging_workspace.load_package_into_workspace()
        self.application.main_view.update_packaging_workspace(self.application.packaging_workspace)

    def show_inner_bag(self):
        underlying_package = self.application.packaging_workspace.underlying_package
        if underlying_package:
            self.st.delete("1.0", "end-1c")
            self.st.insert(1.0, "Loading")
            underlying_package.read_inner_bag()
            self.on_state_change()

    def populate(self):
        self.on_state_change()

    def on_state_change(self):
        underlying_package = self.application.packaging_workspace.underlying_package
        self.showinnerbtn["state"] = DISABLED
        self.repackagebtn["state"] = DISABLED
        if underlying_package:
            self.name.set(underlying_package.name)

            report = underlying_package.report()
            st = self.st
            st.configure(state=tk.NORMAL)
            st.delete("1.0", "end-1c")

            st.insert(1.0, report)
            # st.insert("end-1c", underlying_package.report() + "\n")
            st.configure(state=tk.DISABLED)
            # st.see(tk.END)

            # self.fixity.set(underlying_package.fixity)
            # self.name.set(underlying_package.name)
            # self.algorithms.set(underlying_package.algorithms)
            # self.container.set(underlying_package.container)
            # self.tags.set(underlying_package.tags)
            self.repackagebtn["state"] = NORMAL
            if underlying_package.doublebagged:
                self.showinnerbtn["state"] = NORMAL
            if underlying_package.inner_payload != "?":
                self.showinnerbtn["state"] = DISABLED
