from scattool.shared import has_method
import tkinter

from tkinter import *

from .home import HomePanel
from .metadata import MetadataPanel
from .package import PackagePanel
from .save import SavePanel
from .details import DetailsPanel
from .toolbar import Toolbar

import logging
logger = logging.getLogger(__name__)

class PackagingContext():

    def __init__(self, application):
        logger.info("Setting up application")
        self.application = application
        window = application.window

        panel = MultiFrame(window)
        self.panel = panel
        self.subviews = []
        
        top_banner = Toolbar(application, panel)
        top_banner.pack(fill=X)

        panel.pack(fill=BOTH, expand=True)

        home_panel = HomePanel(panel, self)
        package_panel = PackagePanel(panel, self.application)
        metadata_panel = MetadataPanel(panel, self.application)
        save_panel = SavePanel(panel, self.application)
        details_panel = DetailsPanel(panel, self.application)

        self.add_child_view(home_panel)
        self.add_child_view(package_panel)
        self.add_child_view(metadata_panel)
        self.add_child_view(save_panel)
        self.add_child_view(details_panel)

        self.top_banner = top_banner
        self.main_screen = panel
        self.package_panel = package_panel
        self.metadata_panel = metadata_panel
        self.save_panel = save_panel
        self.details_panel = details_panel

    def add_child_view(self, view):
        self.panel.add_child(view)
        self.subviews.append(view)

    def choose(self, idx):
        if idx == 0:
            self.top_banner.hide_options()
        else:
            self.top_banner.show_first_options()
        self.main_screen.choose(idx)

    def present(self):
        self.top_banner.pack(fill=X)
        self.main_screen.pack(fill=BOTH, expand=True)
        self.top_banner.rebind()

    def showPackageView(self):
        self.choose(4)
        self.details_panel.on_state_change()

    def hide(self):
        self.top_banner.pack_forget()
        self.main_screen.pack_forget()

    def init_workspace(self):
        self.workspace = self.application.fresh_package_workspace()
        self.workspace.add_change_listener(self.state_change)
    
    def new_package(self):
        self.init_workspace()
        self.workspace.start_new_package()
        self.package_panel.switch_package(self.workspace)
        self.metadata_panel.switch_package(self.workspace)
        self.save_panel.switch_package(self.workspace)
        self.details_panel.switch_package(self.workspace)
        self.choose(1)

    def resume_package(self):
        self.init_workspace()
        self.workspace.resume()
        self.package_panel.switch_package(self.workspace)
        self.metadata_panel.switch_package(self.workspace)
        self.save_panel.switch_package(self.workspace)
        self.details_panel.switch_package(self.workspace)
        self.choose(1)
        self.state_change()

    def open_package(self, file_path):
        self.init_workspace()
        self.workspace.open_package(file_path)
        self.package_panel.switch_package(self.workspace)
        self.metadata_panel.switch_package(self.workspace)
        self.save_panel.switch_package(self.workspace)
        self.details_panel.switch_package(self.workspace)
        self.details_panel.populate()
        self.choose(1)
        self.state_change()

    def update_packaging_workspace(self, packaging_workspace):
        self.packaging_workspace = packaging_workspace
        self.packaging_workspace.add_change_listener(self.state_change)
        self.workspace = self.packaging_workspace
        self.package_panel.switch_package(self.packaging_workspace)
        self.metadata_panel.switch_package(self.packaging_workspace)
        self.save_panel.switch_package(self.packaging_workspace)
        self.details_panel.switch_package(self.packaging_workspace)
        self.details_panel.populate()
        self.choose(1)
        self.state_change()

    def state_change(self):
        if (self.workspace.check_package()):
            self.top_banner.show_save()
        for view in self.subviews:
            if has_method(view, "on_state_change"):
                view.on_state_change()

class TextLog():
    def __init__(self):
        self.entries = []
        self.ui = []

    def deregister(self, panel):
        self.ui.remove(panel)

    def register(self, panel):
        text = "\n".join(self.entries)
        self.render_line(panel, text)
        self.ui.append(panel)

    def append_text(self, text):
        self.entries.append(text)
        for panel in self.ui:
            self.render_line(panel, text)

    def render_line(self, panel, text):
        try:
            panel.configure(state=tkinter.NORMAL)
            panel.insert("end-1c", text + "\n")
            panel.configure(state=tkinter.DISABLED)
            panel.see(tkinter.END)
        except Exception as e:
            print("An exception occurred") 
            print(e)

class MultiFrame(Frame):
    def __init__(self, parent, *args, **kwargs):
        kwargs["bg"] = "black"
        Frame.__init__(self, parent, *args, **kwargs)
        self.frames = []

    def add_child(self, inner_frame):
        self.frames.append(inner_frame)

    def choose(self, idx):
        f = self.frames[idx % len(self.frames)]
        for fr in self.frames:
            fr.pack_forget()
        f.pack(fill=BOTH, expand=True)
        print("here1")
        if has_method(f, "rebind"):
            print("here2")
            f.rebind()