import argparse

from scattool.ui import ScatGui

DESC = """
SCAT is Curation and Trust

Launches the SCAT graphical user interface. You can optionally launch in 'config' mode
"""

parser = argparse.ArgumentParser(prog='scat', description=DESC)
parser.add_argument('--config', action='store_true', help='Launch in configuration only mode')
parser.add_argument('--users-only', action='store_true', help='Do not list administrative users in profile selector')

args = parser.parse_args()

app = ScatGui()
app.configure(args)
app.go()