import uuid
import time

class UidMinter:

    def __init__(self, namespace, version=4):
        self.namespace = namespace
        self.version = version

    def uuid(self):
        ##  options included for wider implementation
        ##
        ##  is this out of scope, ? needs to go in scatlib
        ##
        ##  must have institution namespace

        name=""            
        if self.version == 1:
            name = uuid.uuid1()  ##  not yet exercised, ? out of scope
        elif self.version == 3:
            v3_uuid = uuid.uuid3(uuid.NAMESPACE_DNS, self.namespace)
            ##  resolution ten millionth of a second on Linux
            ##  need to check W10
            name = uuid.uuid3(v3_uuid, str(time.time()))  ##  not yet tested
        elif self.version == 4:
            name = uuid.uuid4()  ##  not yet exercised, ? out of scope
        elif self.version == 5:
            v5_uuid = uuid.uuid5(uuid.NAMESPACE_DNS, self.namespace)
            ##  resolution ten millionth of a second on Linux
            ##  need to check W10
            name = uuid.uuid5(v5_uuid, str(time.time()))

        return name

class ChangeNotifier():

    def __init__(self):        
        self.listeners = []

    def add_listener(self, listener):
        self.listeners.append(listener)

    def notify(self):
        for listener in self.listeners:
            listener()