
# Copyright (c) 2021 Metadatis Ltd

import pathlib
from setuptools import setup
from setuptools.command.install import install

import os, glob

def get_data_files():
   message_catalogs = []

   for mo in glob.glob("scattool/locales/*/LC_MESSAGES/scattool.mo"):
      message_catalogs.append((os.path.dirname(mo), (mo,)))

   for t in glob.glob("scattool/locales/*/*.txt"):
      message_catalogs.append((os.path.dirname(t), (t,)))

   return message_catalogs

setup(
   author='ccare',
   author_email='ccare@metadatis.com',
   scripts=['bin/scat_gui.py'],
   data_files=get_data_files(),
   url='http://pypi.python.org/pypi/PackageName/',
   license='LICENSE.txt',
   description='SCAT',
   long_description=open('README.md').read(),
   long_description_content_type="text/markdown",
   install_requires=[
    "bagit",
    "opf-fido"
   ],
   package_data={
      '': ['*.mo', '*.txt']
   },
   include_package_data=True
)