from io import open_code
from scattool.ui.packaging import package
from tkinter import *

from tkinter import font
import tkinter

from scattool.shared import ScatApp, has_method

from .packaging import PackagingContext
from .profiles import *
from .config import ConfigurationStartScreen, EncryptionConfigScreen
from .menu import Menubar

from .help import launch_help
from .logs import launch_log_ui

import tkinter.filedialog as fd
import traceback

import pathlib, site, shutil, traceback


import logging
logger = logging.getLogger(__name__)

class TkApp(Tk):

    def report_callback_exception(self, *args):
        super().report_callback_exception(*args)
        logger.error("Exception occurred on main thread:")
        try:
            for arg in args:
                logger.error("- %s", arg)
        except Exception as e:
            logging.error('Secondary error', exc_info=e)
        try:
            err = traceback.format_exception(*args)
            logger.error("Application error: %s", err)
        except Exception as e:
            logging.error('Secondary error', exc_info=e)
        messagebox.showerror('Application error', 'An error occurred. See logs')

class ScatGui(ScatApp):

    DESC = """
    SCAT is Curation and Trust

    Launches the SCAT graphical user interface. You can optionally launch in 'config' mode
    """

    def __init__(self):
        self.main_view = None

    def show_home_screen(self):
        logger.info("show home")
        self.main_view.choose(0)


    def configure(self, args):
        self.configonly = args.config
        self.usersonly = args.users_only

    def main(self):
        logger.info("Starting UI")
        self.window = window = TkApp()

        window.title("SCAT is Curation and Trust")
        window.geometry('700x600')
        window.minsize(500, 500)
        window['bg']= 'gray50'

        font.Font(family='Helvetica', size=12, weight='bold')
        font.families()

        window.resizable(width = True, height = True)
        menubar = Menubar(window, self)
        window.config(menu=menubar)

        self.menubar = menubar
        self.add_languagelistener(menubar)
        self.add_profilelistener(menubar)

        self.current_profile = None

        self.screens = {}
        self.register_screen("select_profile", ProfilePicker(self, label="Welcome to SCAT: Choose profile", enable_back=False, enable_select=True, users_only=self.usersonly) )
        self.register_screen("pick_profile",ProfilePicker(self, label="Choose profile", enable_select=True, users_only=self.usersonly) )
        self.register_screen("admin_profiles", ProfilePicker(self, enabled_edit=True) )
        self.register_screen("new_profile", CreateProfileScreen(self) )
        self.register_screen("edit_profile", EditProfileScreen(self) )
        self.register_screen("first_configuration", ConfigurationStartScreen(self) )
        self.register_screen("encryption_config", EncryptionConfigScreen(self) )

        if self.usersonly and self.profiles.is_singleusermode():
            self.switch_profile( next(iter(self.profiles.list_users())) )
        elif self.configonly:
            logger.info("Launching in config only mode")
            self.show_screen("first_configuration")
        elif self.configuration.firstrun:
            logger.info("Scat isn't yet intitiatised, launching welcome screen")
            self.show_screen("first_configuration")
        elif self.profiles.firstrun:
            logger.info("Users not yet intitiatised, launching welcome screen")
            self.show_screen("new_profile", forceadmin=True, createanother=True, disablecancel=True, disableback=True)
        else:
            logger.info("Presenting user picker")
            self.show_profile_switcher()

        self.window.mainloop()

    def show_config_screen(self):
        self.show_screen("first_configuration")

    def show_encryption_config_screen(self):
        self.show_screen("encryption_config")

    def edit_profiles(self):
        self.show_screen("admin_profiles", admin=True)

    def show_package_details(self):
        self.main_view.choose(4)
        self.show_screen("main")

    def resume_pkg(self):
        self.main_view.resume_package()

    def new_pkg(self):
        self.main_view.new_package()

    def show_profile_switcher(self):
        self.show_screen("select_profile")

    def register_screen(self, key, presenter):
        self.screens[key] = presenter
        if has_method(presenter, "on_lang_change"):
            self.add_languagelistener(presenter)
        if has_method(presenter, "on_profile_change"):
            self.add_profilelistener(presenter)

    def exit(self):
        self.window.destroy()

    def show_screen(self, screen, **kwargs):
        logger.info("Show %s", screen)
        for k in self.screens:
            self.screens[k].pack_forget()
            if (self.main_view):
                self.main_view.hide()
        if screen == "main":
            self.main_view.present()
        else:
            screen = self.screens[screen]
            screen.present(**kwargs)

    def on_profile_change(self):
        self.main_view = PackagingContext(self)
        self.main_view.choose(0)

    def add_profile(self):
        self.show_screen("new_profile")

    def show_about(self):
        messagebox.showinfo("About SCAT","SCAT version 0.8")

    def open_help(self):
        launch_help(self)

    def open_log_view(self):
        launch_log_ui(self)

    def open_pkg(self):
        logger.info("Opening new package")
        file_paths = fd.askopenfilenames(
            title="Select package to open",
            initialdir=self.workspace.storepath(),
            multiple=False)
        if file_paths and len(file_paths):
            file_path = next(iter(file_paths))
            self.open_package(file_path)

    def open_package(self, file_path):
        # TODO check that we don't have unsaved changes
        logger.info("Opening package %s", file_path)
        self.packaging_workspace.open_package(file_path)
        self.main_view.showPackageView()

    def install_desktop_icon(self):
        # script_file = pathlib.Path(site.getuserbase()) / 'bin' / 'scat_gui.py'
        desktop = pathlib.Path.home() / 'Desktop'
        # if desktop.is_dir():
        #     cmd = desktop / "scat.py"
        #     shutil.copy(script_file, cmd)
        f = open(desktop / "scat.py", "w")
        f.write("import scattool.ui.__main__\n")
        f.close()
