import tkinter.filedialog as fd

from tkinter import ttk
from tkinter import *

import logging
logger = logging.getLogger(__name__)

class PackagePanel(Frame):

    def __init__(self, parent, application):
        self.application = application
        Frame.__init__(self, parent, bg="grey80")
        self.btns = Frame(self, bg="grey80")
        self.btns.pack(side=LEFT, fill=Y)

        add_file_btn = Button(self.btns, text="Add file", command=self.on_add_file)
        add_folder_btn = Button(self.btns, text="Add folder", command=self.on_add_folder)
        add_adjunct_btn = Button(self.btns, text="Add accompaniment", command=self.on_add_adjunct)
        remove_selected_btn = Button(self.btns, text="Remove selected", command=self.on_remove_selected)
        clear_btn = Button(self.btns, text="Clear all", command=self.on_clear)

        add_file_btn.pack(padx=5, pady=(20,5))
        add_folder_btn.pack(padx=5, pady=5)
        add_adjunct_btn.pack(padx=5, pady=5)
        remove_selected_btn.pack(padx=5, pady=5)
        clear_btn.pack(padx=5, pady=5)

        self.tree = ttk.Treeview(self)
        ysb = ttk.Scrollbar(self, orient='vertical', command=self.tree.yview)
        xsb = ttk.Scrollbar(self, orient='horizontal', command=self.tree.xview)
        ysb.pack(side='right', fill='both')
        self.tree.configure(yscrollcommand=ysb.set)
        self.tree['columns'] = ('type')
        self.tree.heading('#0', text='File', anchor='w')
        self.tree.heading('#1', text='Type', anchor='w')
        self.tree.pack(side=LEFT, expand=True, fill=BOTH, padx=20, pady=20, anchor="n")
        self.tree.bind('<<TreeviewOpen>>', self.open_node)

    def switch_package(self, workspace):
        self.workspace = workspace
        self.refresh_tree()

    def refresh_tree(self):
        self.clear_tree()
        state = self.workspace.describe_state()
        if state:
            payload = state["payload"]
            count = 0
            id = None
            for key in payload:
                logger.debug("Rebuild tree %s", key)
                count = count+1
                type = payload[key]['type']
                if (type == "FOLDER"):
                    id = self.tree.insert('', count, text=key, values=(type))
                    folder = payload[key]['src']
                elif (id and payload[key]['folder'] == folder):
                    self.tree.insert(id, count, text=key, values=(type))
                else:
                    self.tree.insert('', count, text=key, values=(type))
            adjuncts = state["adjuncts"]
            for key in adjuncts:
                count = count+1
                self.tree.insert('', count, text=key, values=("ACCOMPANIMENT"))

    def _select_func(selection, model, path, selected, data):
        return False
        
    def clear_tree(self):
        # self.tree.delete(*self.tree.get_children())
        top_nodes = self.tree.get_children("")
        if top_nodes:
            for c in top_nodes:
                print("del")
                print(c)
                self.tree.delete(c)

    def open_node(self, event):
        pass

    def on_add_file(self):
        file_paths = fd.askopenfilenames(title="Select package payload file(s)", initialdir="/home/ccare/Desktop/", multiple=True)
        for file_path in file_paths:
            self.workspace.add_to_payload(file_path)
        self.refresh_tree()

    def on_add_adjunct(self):
        file_paths = fd.askopenfilenames(title="Select accompaniment file(s)", initialdir="/home/ccare/Desktop/", multiple=True)
        for file_path in file_paths:
            self.workspace.add_adjunct(file_path)
        self.refresh_tree()

    def on_add_folder(self):
        path = fd.askdirectory(title="Select a package payload directory", initialdir="/home/ccare/Desktop/")
        self.workspace.add_folder_to_payload(path)
        self.refresh_tree()

    def on_clear(self):
        self.workspace.remove_all_payload()
        self.refresh_tree()
        
    def on_remove_selected(self):
        curItem = self.tree.focus()
        parent = self.tree.parent(curItem)
        if parent:
            print("Tried to remove a file in a folder")
        else:
            self.workspace.remove_from_payload(self.tree.item(curItem).get('text'))
            self.refresh_tree()