import tkinter as tk

from subprocess import check_call
from tkinter import *
from tkinter.scrolledtext import ScrolledText
from tkinter.messagebox import askyesno, askquestion

def launch_log_ui(application):
    logui = LogUi(application.window, application.logs)
    logui.load_files()

class LogUi(Toplevel):

    def __init__(self, root, log_controller):
        super().__init__(root)
        self.title("SCAT Logs")  
        self.geometry("600x400")
        self.log_controller = log_controller
        Label(self, text ="SCAT - Logs").pack()

        buttonbar = Frame(self)
        buttonbar.pack(side=TOP, fill=X)

        deletebtn = Button(buttonbar, text="Delete Selected", command=self.delete_selected)
        deletebtn.pack(side=RIGHT)
        self.deletebtn = deletebtn

        m = PanedWindow(self)
        lb = tk.Listbox(m, selectmode=EXTENDED)
        lb.bind("<<ListboxSelect>>", self.on_select)
        m.add(lb, minsize=200)

        st = ScrolledText(m, width=50,  height=10)
        st.pack(fill=Y, side=RIGHT, expand=True)
        m.add(st)
        m.pack(side=TOP, fill=BOTH, expand=True)

        self.listing = lb
        self.mainview = st

    def load_files(self):
        self.listing.delete(0,'end')
        for label, log_file in self.log_controller.list_logs():
            self.listing.insert('end', label)

    def on_select(self, event):
        print("on select!")
        selection = event.widget.curselection()
        if selection:
            index = selection[0]
            data = event.widget.get(index)
            self.loadview(data)

    def clearview(self):
        self.mainview.configure(state=NORMAL)
        self.mainview.delete('1.0', END)
        self.mainview.configure(state=DISABLED)

    def loadview(self, logfile):
        self.clearview()
        val = self.log_controller.show_log(logfile)
        self.mainview.configure(state=NORMAL)
        self.mainview.insert(1.0, val)
        self.mainview.configure(state=DISABLED)

    def delete_selected(self):
        selection = self.listing.curselection()
        if selection:
            selected_logs = [self.listing.get(idx) for idx in selection]
            if len(selected_logs):
                msg = 'Are you sure that you want to delete %d log files' % len(selected_logs)
                if askyesno(title='Delete confirmation', message=msg):
                    self.remove_logs(selected_logs)

    def remove_logs(self, log_files):
        for f in log_files:
            self.log_controller.remove_log(f)
        self.clearview()
        self.load_files()

