from tkinter import *

class BrowseStore(Frame):

    def __init__(self, parent, *args, **kwargs):
        Frame.__init__(self, parent, *args)
        canvas = Canvas(self, bg="purple")
        scrollbar = Scrollbar(self, orient="vertical", command=canvas.yview)
        scrollable = Frame(canvas, bg="red")
        scrollable.bind(
            "<Configure>",
            lambda e: canvas.configure(
                scrollregion=canvas.bbox("all")
            )
        )
        canvas.create_window((0, 0), window=scrollable, anchor="nw")
        canvas.configure(yscrollcommand=scrollbar.set)
        
        # scrollable.pack(fill=X, expand=True)
        canvas.pack(side="left", fill=BOTH, expand=True)
        
        scrollbar.pack(side="right", fill=Y)

    def on_resize(self, evt):
        print("HERE")