import shutil

import logging
logger = logging.getLogger(__name__)

class LocalStore():

    def __init__(self, storebase):
        self.storebase = storebase

        self.dippath = mkdir(self.storebase / "dip")
        self.aippath = mkdir(self.storebase / "aip")
        self.sippath = mkdir(self.storebase / "sip")

    def packagepath(self, type, package_id):
        return self.storebase / type / package_id

    def add_aip(self, packagepath):
        # TODO belt and braces validation here
        target_location = self.aippath / packagepath.name
        packagepath.rename(target_location)
        logger.info("Saved to %s", target_location)

    def add_dip(self, packagepath):
        target_location = self.dippath / packagepath.name
        packagepath.rename(target_location)
        logger.info("Saved to %s", target_location)

class LocalWorkspace():
    
    def __init__(self, rootpath):
        self.rootpath = rootpath

    def initialise_folders(self):
        # Check we can create the base dir before we go further
        mkdir(self.rootpath)
        # Set up a *nix like file structure, for SCAT
        self.configpath = mkdir(self.rootpath / "etc")
        self.tmppath = mkdir(self.rootpath / "tmp")
        self.varpath = mkdir(self.rootpath / "var")
        # Setup local store
        self.localstore = LocalStore(self.varpath / "local_store")
        self.profilepath = self.varpath / "profiles.json"
        self.configfile = self.configpath / "config.json"
        self.currentpackage = mkdir(self.tmppath / "current")

    def storepath(self):
        return self.localstore.storebase

def mkdir(path):
    logger.debug("Preparing %s", path)
    path.mkdir(parents=True, exist_ok=True)
    return path