import datetime
import logging
from pathlib import Path

class LoggingConfiguration():

    def __init__(self, rootpath):
        self.rootpath = rootpath

    def setup(self):
        self.rootpath.mkdir(parents=True, exist_ok=True)
        log_file = self.rootpath / ("scat-%s.log" % datetime.datetime.now().strftime('%Y%m%d'))

        logging.basicConfig(level=logging.DEBUG,
                    format='%(asctime)s %(name)-12s [%(filename)s:%(lineno)d] %(levelname)-8s %(message)s',
                    datefmt='%Y-%m-%d %H:%M',
                    filename=log_file,
                    filemode='w')

        # define a Handler which writes INFO messages or higher to the sys.stderr
        console = logging.StreamHandler()
        console.setLevel(logging.DEBUG)
        formatter = logging.Formatter('%(name)-12s: [%(filename)s:%(lineno)d]  %(levelname)-8s %(message)s')
        console.setFormatter(formatter)

        # add the handler to the root logger
        logging.getLogger('').addHandler(console)

    def list_logs(self):
        return [ (file.name, file) for file in self.rootpath.glob("*.log") ]

    def show_log(self, name):
        path = self.rootpath / name
        return path.read_text()

    def remove_log(self, name):
        path = self.rootpath / name
        return path.unlink()

